﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[FillerOrderNumberInsert]') AND type in (N'P', N'PC'))
BEGIN 
	DROP PROCEDURE [hips].[FillerOrderNumberInsert] 
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================

-- Create date:   13 October 2015
-- Description:   Inserts a new record into the FillerOrderNumber Table
-- =============================================
CREATE PROCEDURE [hips].[FillerOrderNumberInsert] 
(
	  @CdaSetNumberId INT
	, @FillerOrderNumber VARCHAR(256) = NULL
	, @OrderIdentifier VARCHAR(36) = NULL
	, @UserModified varchar(256)
) 
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode int
          , @FillerOrderNumberId int

    SET @intErrorCode = 0

	INSERT INTO hips.FillerOrderNumber
	(
		CdaSetNumberId,
		FillerOrderNumber,
		OrderIdentifier,
		DateCreated,
        UserCreated,
        DateModified,
        UserModified
		)
VALUES
	(
	  @CdaSetNumberId
	, @FillerOrderNumber
	, @OrderIdentifier
	, GETDATE()
    , @UserModified
    , GETDATE()
    , @UserModified
	)
	
	SELECT @intErrorCode = @@ERROR , @FillerOrderNumberId = SCOPE_IDENTITY()
    IF @intErrorCode = 0
    BEGIN
        SELECT 
			FillerOrderNumberId,
			CdaSetNumberId,
			FillerOrderNumber,
			OrderIdentifier,
			DateCreated,
			UserCreated,
			DateModified,
			UserModified
		FROM  hips.FillerOrderNumber 
		WHERE FillerOrderNumberId = @FillerOrderNumberId
    END

    RETURN(@intErrorCode)

END
